
-- Used for the return value of 'GetGameType' function
GameType = {
	SinglePlayer 	= 3,
	MultiPlayer 	= 4
}

-- Used for 'GetTreasuresNb' and 'RegisterTreasure' functions
TreasureType = {
	Coin 		= 0,
	Goldbar 	= 1,
	Ring 		= 2,
	Chalice 	= 3,
	Cross 		= 4,
	Scepter 	= 5,
	Gecko 		= 6,
	Crown 		= 7,
	Skull 		= 8
}

-- Used for 'GetCurrentPowerup' and 'ClawGivePowerup' functions
Powerup = {
	EndOfLevel       = 0x26AD,
	Warp             = 0x26AE,
	AniRope          = 0x26AF,
	TNTAmmo          = 0x26B0,
	AmmoCurse        = 0x26B1,
	MagicCurse       = 0x26B2,
	HealthCurse      = 0x26B3,
	LifeCurse        = 0x26B4,
	TreasureCurse    = 0x26B5,
	FreezeCurse      = 0x26B6,
	Ghost            = 0x26B7,
	FireSword        = 0x26B8,
	LighteningSword  = 0x26B9, -- old typo, needs to stay
	LightningSword   = 0x26B9,
	IceSword         = 0x26BA,
	PlasmaSword      = 0x26BB,
	Catnip           = 0x26BC,
	Vader            = 0x26BD,
	ExtraLife        = 0x26BE,
	SirenProjectile  = 0x26BF,
	Custom 			 = 0x29A
}

-- Used for 'CreateGoodie' and 'DropGoodies' functions
DropItem = {
	Goldbar = 1,
	RingRed = 2,
	RingGreen = 3,
	RingBlue = 4,
	RingPurple = 5,
	Necklace = 6,
	CrossRed = 7,
	CrossGreen = 8,
	CrossBlue = 9,
	CrossPurple = 10,
	ScepterRed = 11,
	ScepterGreen = 12,
	ScepterBlue = 13,
	ScepterPurple = 14,
	GeckoRed = 15,
	GeckoGreen = 16,
	GeckoBlue = 17,
	GeckoPurple = 18,
	AmmoBigBag = 19,
	Ammo = 20,
	AmmoBag = 21,
	Catnip = 22,
	Catnip2 = 23,
	Food = 24,
	Potion3 = 25,
	Potion1 = 26,
	Potion2 = 27,
	Magic = 28,
	MagicStar = 29,
	MagicClaw = 30,
	EndOfLevel = 31,
	Warp = 32,
	Coin = 33,
	Dynamite = 34,
	AmmoCurse = 35,
	MagicCurse = 36,
	HealthCurse = 37,
	DeathCurse = 38,
	TreasureCurse = 39,
	FreezeCurse = 40,
	ChaliceRed = 41,
	ChaliceGreen = 42,
	ChaliceBlue = 43,
	ChalicePurple = 44,
	CrownRed = 45,
	CrownGreen = 46,
	CrownBlue = 47,
	CrownPurple = 48,
	SkullRed = 49,
	SkullGreen = 50,
	SkullBlue = 51,
	SkullPurple = 52,
	Invisibility = 53,
	Invulnerability = 54,
	ExtraLife = 55,
	FireSword = 56,
	LightningSword = 57,
	IceSword = 58
}

-- Used for 'SetDeathType' function and variable 'LevelBasedData[0].DeathTileType'
DeathType = {
	Spikes 	= 0,
	Goo 	= 1
}

-- Used for 'GetTileA' function
TileAttribute = {
	Clear 	= 0,
	Solid 	= 1,
	Ground 	= 2,
	Climb 	= 3,
	Death 	= 4,
	Mask 	= 6
}

-- Used for 'GetTileA' function
TileType = {
	Single 	= 0x51414C,
	Double 	= 0x51418C,
	Mask 	= 0x5141CC
}

-- Depreciated, use CollisionFlags instead.
ObjectType = {
	Generic		= 1,
	Player		= 2,
	Enemy		= 4,
	PowerUp		= 8,
	Shot		= 0x10,
	PShot		= 0x20,
	EShot		= 0x40,
	Special		= 0x80,
	User1		= 0x100,
	User2		= 0x200
}

--[[ Used for 'BumpFlags', 'HitFlags' and 'AttackFlags' fields of Object.
The CollisionFlags can combined for 'HitFlags' and 'AttackFlags'. Do not combine them for 'BumpFlags'!]]
CollisionFlags = {
	Generic             = 1,
	Player              = 2,
	Enemy               = 4,
	Unknown1			= 8,
	ThrownObject        = 0x10,
	PistolBullet        = 0x20,
	EnemyBullet         = 0x40,
	Platform            = 0x80,
	Special				= 0x100,
	Curse               = 0x200,
	Unknown2			= 0x400,
	Checkpoint          = 0x800,
	JumpSwitch          = 0x1000,
	Unknown3			= 0x2000,
	Unknown4			= 0x4000,
	Unknown5			= 0x8000,
	Health              = 0x10000,
	Unknown6			= 0x20000,
	Treasure            = 0x40000,
	Unknown7			= 0x80000,
	MagicAmmo           = 0x100000,
	Unknown8			= 0x200000,
	Unknown9			= 0x400000,
	PistolAmmo          = 0x800000,
	EnvBullet			= 0x1000000, -- environment bullet (a bullet that can hit both player and enemies)
	MagicBullet			= 0x2000000,
	Sound               = 0x4000000,
}

-- These are the collisions with tiles, the results of object:Physics method. They can be combined with binary OR.
PhysicsFlags = {
	Hit             = 0x10000,
    WallHit         = 0x20000,
    RightHit        = 0x40000,
    LeftHit         = 0x80000,
    DeathLand       = 0x100000,
    ElevatorLand    = 0x200000,
    GroundLand      = 0x400000,
    CeilingHit      = 0x800000,
    FloorHit        = 0x1000000
}

-- Possible values of Object's 'PhysicsType' field
PhysicsTypes = {
	Stand 	= 1,
	Walk 	= 2,
	Jump 	= 3,
	Fall	= 4,
	Duck	= 5,
	Climb	= 6,
	Other	= 7,
	Fly		= 8
}

-- Used for 'SetImgFlag' function
ImageFlag = {
	NoDraw 		= 0,
	Normal 		= 1,
	Ghost 		= 2,
	Shadow 		= 3,
	ColorFill 	= 5,
	Glitch 		= 6,
	Chameleon 	= 6,
	Blob 		= 8
}

-- Used for various functions related to inputs e.g. 'GetInput'. Can be combined with binary OR.
InputFlags = {
	Jump                = 1,
	Attack              = 2,
	Projectile          = 4,
	ToggleProjectile    = 8,
	Unused				= 0x10,
	Lift                = 0x20,
	Pistol              = 0x40,
	Magic               = 0x80,
	Dynamite            = 0x100,
	Special             = 0x200,
	Left                = 0x1000000,
	Right               = 0x2000000,
	Up                  = 0x4000000,
	Down                = 0x8000000
}

-- Used for 'Flags' field of Object.
Flags = {
	NoHit           = 1,
	AlwaysActive    = 2,
	Safe            = 4,
	AutoHitDamage   = 8,
	OnElevator      = 0x10,
	Destroy         = 0x10000,
	OnDeathTile		= 0x400000,
}

-- Used for 'DrawFlags' field of Object.
DrawFlags = {
	NoDraw          = 1,
	Mirror          = 2,
	Invert          = 4,
	Flash           = 8
}

-- Used for global variable 'InfosDisplay[0]'. 
InfosFlags = {
	Objects         = 1,
	Multi           = 2,
	Pos             = 4,
	FPS             = 0x10,
	Timing          = 0x40,
	Watch           = 0x80,
	DebugRects      = 0x1000,
	DebugRectsPlus  = 0x2000,
	DebugText		= 0x4000,
	RealStopwatch   = 0x8000,
	HealthBars      = 0x10000,
	JumpSignal		= 0x20000,
	DebugTiles		= 0x40000
}

-- Used for 'Flags' field of Plane.
PlaneFlags = {
	Main 	= 1,
	NoDraw 	= 2,
	XWrap 	= 4,
	YWrap 	= 8
}

-- Used for 'SpecialFlags' field of Object.
SpecialFlags = {
	StopElevator    = 1,
	Liftable		= 1,
	StartElevator   = 2,
	OneWayElevator  = 0x100,
	Punchable		= 0x400,
	TriggerElevator = 0x1000,
	FireShot        = 0x40000,
	IceShot         = 0x80000,
	LightningShot   = 0x100000
}

--[[ The list of states of the CaptainClaw Object. Example of use:
	local claw = GetClaw()
	local clawIsFalling = claw.State == ClawStates.Fall]]
ClawStates = {
	Jump 		= 4,
	MoveRight 	= 8,
	MoveLeft 	= 9,
	Stand 		= 24,
	Fall 		= 25,
	Crouch 		= 26,
	Climb 		= 27,
	Hit 		= 31,
	Lift 		= 5000,
	Throw 		= 5001,
	Land 		= 5002,
	LookUp 		= 5003,
	DeathFall 	= 5004,
	Death 		= 5005,
	OnEdge 		= 5006,
	Swing 		= 5007,
	Bearhug 	= 5008,
	Freeze 		= 5009
}

-- Chameleon hook states.
chamStates = {
	LoadingAssets 		= 0,
	LoadingObjects 		= 1,
	LoadingStart 		= 2,
	LoadingEnd 			= 3,
	OnPostMessage 		= 4,
	Gameplay 			= 5,
	Reserved1			= 6,
	CustomLevelsDlg		= 7,
	Reserved2			= 8,
	Reserved3			= 9,
	MouseWheel			= 10
}

-- Used for 'GetInterface' function.
InterfaceLogics = {
	ScoreFrame = 0x493E90,
	WeaponFrame = 0x494550,
	HealthFrame = 0x494220,
	LivesFrame = 0x494880,
	TimerFrame = 0x494B20,
	ScoreRibbon = 0x42F840
}

-- Used for 'GetClawAttackType' function.
AttackString = {
	"none",
	"stand_sword_stab",
	"none",
	"stand_straight_punch",
	"stand_hook_punch",
	"stand_pistol_shot",
	"stand_magic_claw",
	"crouch_sword_stab",
	"air_sword_stab",
	"air_pistol_shot",
	"air_magic_claw",
	"none",
	"stand_dynamite_throw",
	"stand_front_kick",
	"crouch_pistol_shot",
	"crouch_magic_claw",
	"crouch_dynamite_throw",
	"none",
	"air_dynamite_throw"
}

-- Used for various input functions e.g. 'KeyPressed'
VKey = {
	LEFT_MOUSE 		= 0x01,
	RIGHT_MOUSE 	= 0x02,
	MIDDLE_MOUSE 	= 0x04,
	BACKSPACE 		= 0x08,
	TAB 			= 0x09,
	ENTER 			= 0x0D,
	SHIFT 			= 0x10,
	CONTROL 		= 0x11,
	ALT 			= 0x12,
	PAUSE 			= 0x13,
	CAPS_LOCK		= 0x14,
	ESCAPE 			= 0x1B,
	SPACE 			= 0x20,
	PAGE_UP 		= 0x21,
	PAGE_DOWN 		= 0x22,
	END 			= 0x23,
	HOME 			= 0x24,
	LEFT_ARROW 		= 0x25,
	UP_ARROW 		= 0x26,
	RIGHT_ARROW 	= 0x27,
	DOWN_ARROW 		= 0x28,
	PRINT_SCREEN 	= 0x2C,
	INSERT 			= 0x2D,
	DELETE 			= 0x2E,
	["0"]	= 0x30,
	["1"]	= 0x31,
	["2"]	= 0x32,
	["3"]	= 0x33,
	["4"]	= 0x34,
	["5"]	= 0x35,
	["6"]	= 0x36,
	["7"]	= 0x37,
	["8"]	= 0x38,
	["9"]	= 0x39,
	A 		= 0x41,
	B 		= 0x42,
	C 		= 0x43,
	D 		= 0x44,
	E 		= 0x45,
	F 		= 0x46,
	G 		= 0x47,
	H 		= 0x48,
	I 		= 0x49,
	J 		= 0x4A,
	K 		= 0x4B,
	L 		= 0x4C,
	M 		= 0x4D,
	N 		= 0x4E,
	O 		= 0x4F,
	P 		= 0x50,
	Q 		= 0x51,
	R 		= 0x52,
	S 		= 0x53,
	T 		= 0x54,
	U 		= 0x55,
	V 		= 0x56,
	W 		= 0x57,
	X 		= 0x58,
	Y 		= 0x59,
	Z 		= 0x5A,
	NUM0 	= 0x60,
	NUM1 	= 0x61,
	NUM2 	= 0x62,
	NUM3 	= 0x63,
	NUM4 	= 0x64,
	NUM5 	= 0x65,
	NUM6 	= 0x66,
	NUM7 	= 0x67,
	NUM8 	= 0x68,
	NUM9 	= 0x69,
	F1 		= 0x70,
	F2 		= 0x71,
	F3 		= 0x72,
	F4 		= 0x73,
	F5 		= 0x74,
	F6 		= 0x75,
	F7 		= 0x76,
	F8 		= 0x77,
	F9 		= 0x78,
	F10 	= 0x79,
	F11 	= 0x7A,
	F12 	= 0x7B
}

-- the list of all built-in logics
BuiltInLogics = {
    CaptainClaw 				= 0x416EE0,
    CaptainClawHit 				= 0x41E210,
    CaptainClawRemoteRacer 		= 0x42F440,
    CaptainClawScreenPosition 	= 0x4893B0,
    ClawMultiRacer 				= 0x42F390,
    Flare 						= 0x459C50,
    WolvingtonLFX 				= 0x459E00,
    Bullet 						= 0x410510,
    MagicBullet 				= 0x4107F0,
    FireBullet					= 0x410960,
    LightningBullet				= 0x410AD0,
    IceBullet					= 0x410C40,
    PistolBullet				= 0x410680,
    CannonBall					= 0x415940,
    WolvingtonBullet			= 0x410DB0,
    OmarBullet					= 0x410F20,
    SirenBullet					= 0x411090,
    TridentBullet				= 0x411200,
    RedTailKnife				= 0x411370,
    RedTailBullet				= 0x4114E0,
    LogicHit					= 0x4DEF10,
    LogicAttack					= 0x4DEF20,
    Officer						= 0x464850,
    Soldier						= 0x48DC20,
    Raux						= 0x480B40,
    Rat							= 0x47F0C0,
    PunkRat						= 0x475E90,
    RatBomb						= 0x480090,
    GroundCannon				= 0x44ABF0,
    SkullCanon					= 0x48DA20,
    TowerCannonRight			= 0x499600,
    TowerCannonLeft				= 0x499770,
    PowderKeg					= 0x470DD0,
    BouncingGoodie				= 0x40EBB0,
    CutThroat					= 0x439170,
    RobberThief					= 0x4883E0,
    Katherine					= 0x4555D0,
    TownGuard1					= 0x499A10,
    TownGuard2					= 0x49A1F0,
    BearSailor					= 0x40A020,
    RedTailPirate				= 0x485060,
    RedTail						= 0x481EF0,
    Wolvington					= 0x4A36C0,
    Omar						= 0x465870,
    OmarShield					= 0x4673C0,
    GooVent						= 0x449C70,
    Laser						= 0x456C70,
    Crate						= 0x434AC0,
    FrontStackedCrates			= 0x490820,
    BackStackedCrates			= 0x4909A0,
    AniRope						= 0x403130,
    Dynamite					= 0x43BC00,
    BreakPlank					= 0x40FD20,
    SinglePlank					= 0x48BF90,
    Seagull						= 0x48A020,
    Shake						= 0x48B800,
    JumpSwitch					= 0x4552D0,
    HermitCrab					= 0x44B500,
    TProjectile					= 0x49B890,
    GroundBlower				= 0x44A440,
    CrabNest					= 0x433EE0,
    ConveyorBelt				= 0x432B70,
    BackgroundLogic				= 0x409770,
    CrabBomb					= 0x4335E0,
    Stalactite					= 0x491990,
    CrazyHook					= 0x435BA0,
    PegLeg						= 0x46AC10,
    Fish						= 0x443020,
    CanonSwitch					= 0x416310,
    GabrielCannon				= 0x447950,
    Gabriel						= 0x444650,
    GabrielBomb					= 0x446D50,
    CannonButton				= 0x415B70,
    Aquatis						= 0x404510,
    AquatisCrack				= 0x406740,
    Tentacle					= 0x495870,
    AquatisDynamite				= 0x407200,
    EndLevelGem					= 0x43DBF0,
    AquatisStalactite			= 0x407910,
    Siren						= 0x48C940,
    FallingDebris				= 0x4425A0,
    LavaGeyser					= 0x457360,
    LavaMouth					= 0x459250,
    LavaHand					= 0x457C20,
    LavaHandProjectile			= 0x458670,
    Chameleon					= 0x422290,
    TigerGuard					= 0x4977B0,
    Mercat						= 0x461E50,
    WindDebris					= 0x4A2C00,
    RedTailWind					= 0x487070,
    RedTailSpikes				= 0x486A50,
    Parrot						= 0x467AE0,
    Marrow						= 0x45A600,
    MarrowFloor					= 0x45C380,
    ScoreFrame					= 0x493E90,
    WeaponFrame					= 0x494550,
    HealthFrame					= 0x494220,
    LivesFrame					= 0x494880,
    TimerFrame					= 0x494B20,
    StatusNumberDigit			= 0x494FB0,
    ScoreRibbon					= 0x42F840,
    MultiStats					= 0x495480,
    GoldPowerup					= 0x471CE0,
    HealthPowerup				= 0x4728D0,
    PowerupGlitter				= 0x471CF0,
    EndOfLevelPowerup			= 0x471D90,
    SpecialPowerup				= 0x472000,
    CratePowerup				= 0x4730C0,
    FrontCrate					= 0x4732B0,
    BehindCrate					= 0x4732E0,
    FrontStatue					= 0x473310,
    BehindStatue				= 0x473340,
    CrateHit					= 0x473370,
    CoinPowerup					= 0x471CE0,
    TreasurePowerup				= 0x471900,
    MagicPowerup				= 0x472AC0,
    SuperPowerup				= 0x472ED0,
    AmmoPowerup					= 0x472CB0,
    GlitterlessPowerup			= 0x471CE0,
    PointsIcon					= 0x475660,
    CursePowerup				= 0x472600,
    BossWarp					= 0x472450,
    Checkpoint					= 0x424470,
    CheckpointAttack			= 0x424570,
    CheckpointTimer				= 0x4950F0,
    FirstSuperCheckpoint		= 0x424840,
    SecondSuperCheckpoint		= 0x424860,
    SuperCheckpointAttack		= 0x424720,
    StandardElevator			= 0x4A05C0,
    SlidingElevator				= 0x4A0F30,
    StartElevator				= 0x4A16A0,
    StopElevator				= 0x4A1720,
    SpringBoard					= 0x4A1740,
    WaterRock					= 0x4A19B0,
    Elevator					= 0x4A1E40,
    OneWayStartElevator			= 0x4A16E0,
    OneWayTriggerElevator		= 0x4A1700,
    TriggerElevator				= 0x4A16C0,
    PathElevator				= 0x4A29C0,
    SteppingStone				= 0x4A23B0,
    SteppingStone2				= 0x4A2670,
    SteppingStone3				= 0x4A2690,
    SteppingStone4				= 0x4A26B0,
    StartSteppingStone			= 0x4A26D0,
    OneTimeSteppingStone		= 0x4A29B0,
    CrumblingPeg				= 0x4A1430,
    CrumblingPegNoRespawn		= 0x4A1230,
    TogglePeg					= 0x4A2080,
    TogglePeg2					= 0x4A2350,
    TogglePeg3					= 0x4A2370,
    TogglePeg4					= 0x4A2390,
    AniCycle					= 0x494E60,
    AniCycleNormal				= 0x494E60,
    ChildChar					= 0x42F5B0,
    ChildScoreNum				= 0x42F660,
    ChildRibbon					= 0x42F760,
    Message						= 0x494EC0,
    SingleFrameMessage			= 0x494F30,
    DoNothingNormal				= 0x463690,
    DoNothing					= 0x463670,
    BehindCandy					= 0x463710,
    FrontCandy					= 0x4636B0,
    BehindAniCandy				= 0x4638B0,
    FrontAniCandy				= 0x463820,
    GlitterMother				= 0x449A90,
    GlitterBaby					= 0x449BF0,
    GooCoverup					= 0x463770,
    GooBubble					= 0x4637B0,
    HitBurst					= 0x4639D0,
    Splash						= 0x463B00,
    BlinkingEyes				= 0x463CE0,
    FloorSpike					= 0x463DB0,
    FloorSpike2					= 0x464040,
    FloorSpike3					= 0x464060,
    FloorSpike4					= 0x464080,
    SawBlade					= 0x4640A0,
    SawBlade2					= 0x464350,
    SawBlade3					= 0x464370,
    SawBlade4					= 0x464390,
    TreasureCounter				= 0x49C3C0,
    SimpleAnimation				= 0x49CA30,
    TreasureLogic				= 0x49CA80,
    MapPieceLogic				= 0x40C730,
    AmuletGemLogic				= 0x40D7C0,
    MapProgressLogic			= 0x40CAE0,
    StationaryLight				= 0x45A510,
    ChildLight					= 0x45A580,
    MenuSparkle					= 0x461820,
    MenuClaw					= 0x4614D0,
    SoundTrigger				= 0x48F440,
    BigSoundTrigger				= 0x48F660,
    SmallSoundTrigger			= 0x48F680,
    TinySoundTrigger			= 0x48F6C0,
    HugeSoundTrigger			= 0x48F6A0,
    TallSoundTrigger			= 0x48F6E0,
    WideSoundTrigger			= 0x48F700,
    ClawDialogSound				= 0x48F880,
    EnemyDialogSound			= 0x48FEC0,
    ClawDialogSoundTrigger		= 0x48FB50,
    ClawDialogBigSoundTrigger	= 0x48FCA0,
    ClawDialogSmallSoundTrigger	= 0x48FCC0,
    ClawDialogTinySoundTrigger	= 0x48FD00,
    ClawDialogHugeSoundTrigger	= 0x48FCE0,
    ClawDialogTallSoundTrigger	= 0x48FD20,
    ClawDialogWideSoundTrigger	= 0x48FD40,
    GlobalAmbientSound			= 0x402CB0,
    AmbientSound				= 0x402CD0,
    AmbientPosSound				= 0x402E30,
    SpotAmbientSound			= 0x402E50,
    BossStager					= 0x4913D0,
    BossStagerAttack			= 0x491920,
    BossHealthMeter				= 0x495550
}

-- the list of messages
_message = {
	-- main game events/states (the list's incomplete):
	LevelStart 				= 0x8005,
	ExitGame 				= 0x8008,
	LevelEnd 				= 0x800E,
	PreviousLevel 			= 0x800F,
	IncreasePlayArea 		= 0x801B,
	DecreasePlayArea 		= 0x801C,
	Credits 				= 0x8021,
	ExitLevel				= 0x8023,
	Multiplayer 			= 0x8025,
	HelpScreen 				= 0x8035,
	BackToGame 				= 0x8036,
	RunGame					= 0x8036,
	UploadScores 			= 0x8039,
	ClawDeath 				= 0x803A,
	OpenCustomLevelWindow 	= 0x8042,
	Teleport 				= 0x805C,
	EditMacros				= 0x8059,
	ClawSuicide 			= 0x8063,
	Booty 					= 0x807C,
	LoadGame 				= 0x807E,
	NewGame 				= 0x807F,
	InGameMenu 				= 0x8080,
	OpenWindow 				= 0x8090, -- opens a dialog box, dialog type can be specified in wparam
	-- Original cheats:
	MPSCULLY			= 0x800E,
	MPMOULDER 			= 0x800F,
	MPKFA				= 0x8043,
	MPAPPLE 			= 0x8044,
	MPLOADED 			= 0x8045,
	MPGANDOLF 			= 0x8046,
	MPBUNZ 				= 0x8047,
	MPMOONGOODIES 		= 0x8049,
	MPJORDAN 			= 0x804A,
	MPFPS 				= 0x804B,
	MPPOS 				= 0x804C,
	MPBOUNCECOUNT 		= 0x804D,
	MPNOINFO 			= 0x804E,
	MPSUPERTHROW 		= 0x804F,
	MPFREAK 			= 0x805B,
	MPTOPLESS 			= 0x8064,
	MPMIDLESS 			= 0x8065,
	MPBOTTOMLESS 		= 0x8066,
	MPWIMPY 			= 0x806A,
	MPBLASTER 			= 0x806C,
	MPSTOPWATCH 		= 0x806E,
	MPPLAYALLDAY 		= 0x8071,
	MPARMOR 			= 0x8072,
	MPJAZZY 			= 0x8076,
	MPINCVID 			= 0x8077,
	MPDECVID 			= 0x8078,
	MPDEFVID 			= 0x8079,
	MPGOBLE 			= 0x807A,
	MPMONOLITH 			= 0x8086,
	MPDEVHEADS 			= 0x8087,
	MPSPOOKY 			= 0x8088,
	MPSHADOW 			= 0x8089,
	MPHAUNTED 			= 0x808A,
	MPCULTIST 			= 0x808B,
	MPCASPER 			= 0x808D,
	MPVADER 			= 0x808E,
	MPPENGUIN 			= 0x8091,
	MPHOTSTUFF 			= 0x8092,
	MPFRANKLIN 			= 0x8093,
	MPSKINNER 			= 0x80AA,
	MPGLOOMY 			= 0x80AD,
	MPNOISE 			= 0x80AE,
	MPMAESTRO 			= 0x80AF,
	MPLANGSAM 			= 0x80B0,
	MPNORMALMUSIC 		= 0x80B1,
	MPLONGRANGE 		= 0x80B2,
	MPBOUNCECOUNTER 	= 0x80B3,
	MPWILDWACKY 		= 0x80B4,
	MPEASYMODE 			= 0x80B5,
	MPTWINTURBO 		= 0x80B6,
	-- Jump to level cheats:
	MPCHEESESAUCE 		= 0x809C,
	MPEXACTLY 			= 0x809D,
	MPRACEROHBOY 		= 0x809E,
	MPBUDDYWHAT 		= 0x809F,
	MPMUGGER 			= 0x80A0,
	MPGOOFCYCLE 		= 0x80A1,
	MPROTARYPOWER 		= 0x80A2,
	MPSHIBSHANK 		= 0x80A3,
	MPWHYZEDF 			= 0x80A4,
	MPSUPERHAWK 		= 0x80A5,
	MPJOBNUMBER 		= 0x80A6,
	MPLISTENANDLEARN 	= 0x80A7,
	MPYEAHRIGHT 		= 0x80A8,
	MPCLAWTEAMTULEZ 	= 0x80A9,
	-- CrazyHook cheats:
	MPZAX				= 0x1000,
	MPARTUR				= 0x1001,
	MPFLY				= 0x1002,
	MPKIJAN				= 0x1003,
	MPRECTS				= 0x1004,
	MPMOREDI			= 0x1005,
	MPTEXT				= 0x1006,
	MPSPEEDRUN			= 0x1007,
	MPAZZAR				= 0x1008,
	MPBUTTER			= 0x1009,
	MPBORIS				= 0x1010,
	MPPAPPY				= 0x1011,
	MPPEJTI				= 0x1012,
	MPWISZTOM			= 0x1013,
	MPTHANOS			= 0x1014,
	MPGONZALO			= 0x1015,
	MPALICE				= 0x1016,
	MPNDJ				= 0x1017,
	MPSIMPSON			= 0x1018,
	MPTILES				= 0x1019,
	-- CrazyHook core:
	ChangeResWrapper 	= 0x901,
	BnWWrapper			= 0x902,
	ArgvsResNoperReset	= 0x903,
	ArgvsChangeRes		= 0x904
}
