--------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------- [[ Config Controls module ]] ----------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------
--[[ The main purpose of this module is to add the possibility to change the default arrow keys for movement/climbing/crouch from the
game's options.]]

--[[
CONFIG_CONTROLS DIALOG 0, 0, 200, 252
STYLE DS_SETFONT | DS_MODALFRAME | DS_CENTER | WS_POPUP
CAPTION ""
LANGUAGE LANG_ENGLISH, SUBLANG_ENGLISH_US
FONT 8, "MS Sans Serif"
{
   CONTROL "", 1043, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 43, 55, 100 
   CONTROL "", 1042, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 43, 55, 100 
   CONTROL "", 1045, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 56, 55, 100 
   CONTROL "", 1044, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 56, 55, 100 
   CONTROL "", 1047, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 69, 55, 100 
   CONTROL "", 1046, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 69, 55, 100 
   CONTROL "", 1049, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 82, 55, 100 
   CONTROL "", 1048, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 82, 55, 100 
   CONTROL "", 1053, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 95, 55, 100 
   CONTROL "", 1052, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 95, 55, 100 
   CONTROL "", 1055, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 108, 55, 100 
   CONTROL "", 1054, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 108, 55, 100 
   CONTROL "", 1057, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 121, 55, 100 
   CONTROL "", 1056, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 121, 55, 100 
   CONTROL "", 1059, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 134, 55, 100 
   CONTROL "", 1058, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 134, 55, 100 
   CONTROL "", 1061, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 147, 55, 100 
   CONTROL "", 1060, COMBOBOX, CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 138, 147, 55, 100
   CONTROL "", 1063, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 160, 55, 100 
   CONTROL "", 1064, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 173, 55, 100 
   CONTROL "", 1065, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 186, 55, 100 
   CONTROL "", 1066, COMBOBOX, CBS_DROPDOWNLIST | CBS_SORT | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP, 77, 199, 55, 100 
   CONTROL "OK", 1, BUTTON, BS_DEFPUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 13, 231, 50, 14 
   CONTROL "Defaults", 1062, BUTTON, BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 75, 231, 50, 14 
   CONTROL "Cancel", 2, BUTTON, BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 137, 231, 50, 14 
   CONTROL "Jump:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 45, 64, 8 
   CONTROL "Hand Attack:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 58, 64, 8 
   CONTROL "Projectile Attack:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 71, 64, 8 
   CONTROL "Projectile Toggle:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 84, 64, 8 
   CONTROL "Throw:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 97, 64, 8 
   CONTROL "Pistol Attack:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 110, 64, 8 
   CONTROL "Magic Attack:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 123, 64, 8 
   CONTROL "Dynamite Attack:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 136, 64, 8 
   CONTROL "Special Attack:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 149, 64, 8 
   CONTROL "Move Left:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 162, 64, 8 
   CONTROL "Move Right:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 175, 64, 8 
   CONTROL "Climb Up:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 188, 64, 8 
   CONTROL "Crouch:", -1, STATIC, SS_RIGHT | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 201, 64, 8 
   CONTROL "Controller Configuration", 1099, STATIC, SS_CENTER | SS_SUNKEN | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 7, 186, 10 
   CONTROL "Disable Joystick", 1108, BUTTON, BS_AUTOCHECKBOX | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 77, 214, 116, 10 
}
]]

local bytes = [[
C0 08 00 80 00 00 00 00 28 00 00 00 00 00 C8 00 
FC 00 00 00 00 00 00 00 08 00 4D 00 53 00 20 00 
53 00 61 00 6E 00 73 00 20 00 53 00 65 00 72 00 
69 00 66 00 00 00 00 00 03 01 21 50 00 00 00 00 
4D 00 2B 00 37 00 64 00 13 04 FF FF 85 00 00 00 
00 00 00 00 03 00 21 50 00 00 00 00 8A 00 2B 00 
37 00 64 00 12 04 FF FF 85 00 00 00 00 00 00 00 
03 01 21 50 00 00 00 00 4D 00 38 00 37 00 64 00 
15 04 FF FF 85 00 00 00 00 00 00 00 03 00 21 50 
00 00 00 00 8A 00 38 00 37 00 64 00 14 04 FF FF 
85 00 00 00 00 00 00 00 03 01 21 50 00 00 00 00 
4D 00 45 00 37 00 64 00 17 04 FF FF 85 00 00 00 
00 00 00 00 03 00 21 50 00 00 00 00 8A 00 45 00 
37 00 64 00 16 04 FF FF 85 00 00 00 00 00 00 00 
03 01 21 50 00 00 00 00 4D 00 52 00 37 00 64 00 
19 04 FF FF 85 00 00 00 00 00 00 00 03 00 21 50 
00 00 00 00 8A 00 52 00 37 00 64 00 18 04 FF FF 
85 00 00 00 00 00 00 00 03 01 21 50 00 00 00 00 
4D 00 5F 00 37 00 64 00 1D 04 FF FF 85 00 00 00 
00 00 00 00 03 00 21 50 00 00 00 00 8A 00 5F 00 
37 00 64 00 1C 04 FF FF 85 00 00 00 00 00 00 00 
03 01 21 50 00 00 00 00 4D 00 6C 00 37 00 64 00 
1F 04 FF FF 85 00 00 00 00 00 00 00 03 00 21 50 
00 00 00 00 8A 00 6C 00 37 00 64 00 1E 04 FF FF 
85 00 00 00 00 00 00 00 03 01 21 50 00 00 00 00 
4D 00 79 00 37 00 64 00 21 04 FF FF 85 00 00 00 
00 00 00 00 03 00 21 50 00 00 00 00 8A 00 79 00 
37 00 64 00 20 04 FF FF 85 00 00 00 00 00 00 00 
03 01 21 50 00 00 00 00 4D 00 86 00 37 00 64 00 
23 04 FF FF 85 00 00 00 00 00 00 00 03 00 21 50 
00 00 00 00 8A 00 86 00 37 00 64 00 22 04 FF FF 
85 00 00 00 00 00 00 00 03 01 21 50 00 00 00 00 
4D 00 93 00 37 00 64 00 25 04 FF FF 85 00 00 00 
00 00 00 00 03 00 21 50 00 00 00 00 8A 00 93 00 
37 00 64 00 24 04 FF FF 85 00 00 00 00 00 00 00 
03 01 21 50 00 00 00 00 4D 00 A0 00 37 00 64 00 
27 04 FF FF 85 00 00 00 00 00 00 00 03 01 21 50 
00 00 00 00 4D 00 AD 00 37 00 64 00 28 04 FF FF 
85 00 00 00 00 00 00 00 03 01 21 50 00 00 00 00 
4D 00 BA 00 37 00 64 00 29 04 FF FF 85 00 00 00 
00 00 00 00 03 01 21 50 00 00 00 00 4D 00 C7 00 
37 00 64 00 2A 04 FF FF 85 00 00 00 00 00 00 00 
01 00 01 50 00 00 00 00 0D 00 E7 00 32 00 0E 00 
01 00 FF FF 80 00 4F 00 4B 00 00 00 00 00 00 00 
00 00 01 50 00 00 00 00 4B 00 E7 00 32 00 0E 00 
26 04 FF FF 80 00 44 00 65 00 66 00 61 00 75 00 
6C 00 74 00 73 00 00 00 00 00 00 00 00 00 01 50 
00 00 00 00 89 00 E7 00 32 00 0E 00 02 00 FF FF 
80 00 43 00 61 00 6E 00 63 00 65 00 6C 00 00 00 
00 00 00 00 02 00 02 50 00 00 00 00 07 00 2D 00 
40 00 08 00 FF FF FF FF 82 00 4A 00 75 00 6D 00 
70 00 3A 00 00 00 00 00 02 00 02 50 00 00 00 00 
07 00 3A 00 40 00 08 00 FF FF FF FF 82 00 48 00 
61 00 6E 00 64 00 20 00 41 00 74 00 74 00 61 00 
63 00 6B 00 3A 00 00 00 00 00 00 00 02 00 02 50 
00 00 00 00 07 00 47 00 40 00 08 00 FF FF FF FF 
82 00 50 00 72 00 6F 00 6A 00 65 00 63 00 74 00 
69 00 6C 00 65 00 20 00 41 00 74 00 74 00 61 00 
63 00 6B 00 3A 00 00 00 00 00 00 00 02 00 02 50 
00 00 00 00 07 00 54 00 40 00 08 00 FF FF FF FF 
82 00 50 00 72 00 6F 00 6A 00 65 00 63 00 74 00 
69 00 6C 00 65 00 20 00 54 00 6F 00 67 00 67 00 
6C 00 65 00 3A 00 00 00 00 00 00 00 02 00 02 50 
00 00 00 00 07 00 61 00 40 00 08 00 FF FF FF FF 
82 00 54 00 68 00 72 00 6F 00 77 00 3A 00 00 00 
00 00 00 00 02 00 02 50 00 00 00 00 07 00 6E 00 
40 00 08 00 FF FF FF FF 82 00 50 00 69 00 73 00 
74 00 6F 00 6C 00 20 00 41 00 74 00 74 00 61 00 
63 00 6B 00 3A 00 00 00 00 00 00 00 02 00 02 50 
00 00 00 00 07 00 7B 00 40 00 08 00 FF FF FF FF 
82 00 4D 00 61 00 67 00 69 00 63 00 20 00 41 00 
74 00 74 00 61 00 63 00 6B 00 3A 00 00 00 00 00 
02 00 02 50 00 00 00 00 07 00 88 00 40 00 08 00 
FF FF FF FF 82 00 44 00 79 00 6E 00 61 00 6D 00 
69 00 74 00 65 00 20 00 41 00 74 00 74 00 61 00 
63 00 6B 00 3A 00 00 00 00 00 00 00 02 00 02 50 
00 00 00 00 07 00 95 00 40 00 08 00 FF FF FF FF 
82 00 53 00 70 00 65 00 63 00 69 00 61 00 6C 00 
20 00 41 00 74 00 74 00 61 00 63 00 6B 00 3A 00 
00 00 00 00 02 00 02 50 00 00 00 00 07 00 A2 00 
40 00 08 00 FF FF FF FF 82 00 4D 00 6F 00 76 00 
65 00 20 00 4C 00 65 00 66 00 74 00 3A 00 00 00 
00 00 00 00 02 00 02 50 00 00 00 00 07 00 AF 00 
40 00 08 00 FF FF FF FF 82 00 4D 00 6F 00 76 00 
65 00 20 00 52 00 69 00 67 00 68 00 74 00 3A 00 
00 00 00 00 02 00 02 50 00 00 00 00 07 00 BC 00 
40 00 08 00 FF FF FF FF 82 00 43 00 6C 00 69 00 
6D 00 62 00 20 00 55 00 70 00 3A 00 00 00 00 00 
02 00 02 50 00 00 00 00 07 00 C9 00 40 00 08 00 
FF FF FF FF 82 00 43 00 72 00 6F 00 75 00 63 00 
68 00 3A 00 00 00 00 00 01 10 02 50 00 00 00 00 
07 00 07 00 BA 00 0A 00 4B 04 FF FF 82 00 43 00 
6F 00 6E 00 74 00 72 00 6F 00 6C 00 6C 00 65 00 
72 00 20 00 43 00 6F 00 6E 00 66 00 69 00 67 00 
75 00 72 00 61 00 74 00 69 00 6F 00 6E 00 00 00 
00 00 00 00 03 00 01 50 00 00 00 00 4D 00 D6 00 
74 00 0A 00 54 04 FF FF 80 00 44 00 69 00 73 00 
61 00 62 00 6C 00 65 00 20 00 4A 00 6F 00 79 00 
73 00 74 00 69 00 63 00 6B 00 00 00 00 00 00 00 
]]

local hexStrToMem = function(addr, string)
	local bin = ffi.cast("char*",addr)
	local i = 0
	for v in string.gmatch(string, "(%x+)") do
		bin[i] = tonumber(v, 16)
		i = i+1
	end
end

local sInt = function(addr, int)
   ffi.cast("int*", addr)[0] = int
end

do -- read and map movement controls from CLAW.USR
   hexStrToMem(0x432405, "E9 2D C2 FF FF 90")
   hexStrToMem(0x42E637, "8B 50 04 89 51 38 8B 50 08 89 51 3C 8B 50 0C 89 51 40 8B 50 10 89 51 44 8B 50 14 89 51 48 E9 B1 3D 00 00 90")
end

do -- save movement controls to CLAW.USR
   hexStrToMem(0x4324B5, "E9 EE 92 0D 00 90")
   hexStrToMem(0x50B7A8, "8B 51 38 89 50 04 8B 51 3C 89 50 08 8B 51 40 89 50 0C 8B 51 44 89 50 10 8B 51 48 89 50 14 E9 F0 6C F2 FF 90")
end

do -- save a dialog type that is about to open to the *((int*)0x42E670)
   hexStrToMem(0x427E74, "90 90 E9 E0 67 00 00")
   hexStrToMem(0x42E65B, "8B 8C 24 1C 01 00 00 89 0D 70 E6 42 00 E9 0E 98 FF FF 90 90 90")
   hexStrToMem(0x42E670, "00 00 00 00")
   hexStrToMem(0x42E674, "90 90 90 90 90 90 90 90")
end

do -- register keyboard arrow keys in control config dialog's combo-boxes
   hexStrToMem(0x431ED4, "E9 1B 97 0D 00")
   hexStrToMem(0x50B5F4, "68 C4 B5 50 00 89 F1 E8 D6 10 FF FF C7 00 25 00 00 00 68 D0 B5 50 00 89 F1 E8 C4 10 FF FF C7 00 27 00 00 00 68 DC B5 50 00 89 F1 E8 B2 10 FF FF C7 00 26 00 00 00 68 E8 B5 50 00 89 F1 E8 A0 10 FF FF C7 00 28 00 00 00 68 80 46 52 00 E9 93 68 F2 FF")
end

do -- fix or replace a few keys that are registered with ASCII codes, instead of VKey
   sInt(0x4322CD, 0x50B7CC) sInt(0x4322E7, 1) -- replace -_ key with LMOUSE (dash is already used to shrink the gameplay area)
   sInt(0x4322DF, 0x50B7D4) sInt(0x4322F9, 2) -- replace =+ key with RMOUSE (equal sign is already used to expand the gameplay area)
   sInt(0x432304, 0xBC) -- fix ,< key
   sInt(0x43231D, 0xBE) -- fix .> key
   sInt(0x43232F, 0xBF) -- fix /? key
   sInt(0x432341, 0xBA) -- fix ;: key
   sInt(0x432353, 0xDE) -- fix '" key
   -- instead of fixing some keys that no one will use, I'm replacing them with the mouse buttons:
   sInt(0x43234B, 0x50B7DC) sInt(0x432365, 5) -- [{ key to X1MOUSE
   sInt(0x43235D, 0x50B7E4) sInt(0x432377, 6) -- ]} key to X2MOUSE
   sInt(0x43236F, 0x50B750) sInt(0x432384, 4) -- \| key to MMOUSE
end

do -- strings literals
   hexStrToMem(0x50B5C0, "90 90 90 90") -- NOPs
   hexStrToMem(0x50B5C4, "4C 45 46 54 00 00 00 00 00 00 00 00") -- "LEFT"
   hexStrToMem(0x50B5D0, "52 49 47 48 54 00 00 00 00 00 00 00") -- "RIGHT"
   hexStrToMem(0x50B5DC, "55 50 00 00 00 00 00 00 00 00 00 00") -- "UP"
   hexStrToMem(0x50B5E8, "44 4F 57 4E 00 00 00 00 00 00 00 00") -- "DOWN"
   hexStrToMem(0x50B750, "4D 4D 4F 55 53 45 00 00") -- "MMOUSE"
   hexStrToMem(0x50B7CC, "4C 4D 4F 55 53 45 00 00") -- "LMOUSE"
   hexStrToMem(0x50B7D4, "52 4D 4F 55 53 45 00 00") -- "RMOUSE"
   hexStrToMem(0x50B7DC, "58 31 4D 4F 55 53 45 00") -- "X1MOUSE"
   hexStrToMem(0x50B7E4, "58 32 4D 4F 55 53 45 00") -- "X2MOUSE"
end

do -- replace the control config's dialog template and its size 
   hexStrToMem(0x4E5336, "90 90 90 E9 09 63 02 00")
   hexStrToMem(0x50B646, "90") -- nop
   hexStrToMem(0x50B647, "51 8B 0D 70 E6 42 00 85 C9 59 75 0A BB 00 00 00 80 B8 30 06 00 00 89 C6 56 E8 85 14 FF FF E9 D4 9C FD FF 90 90")
end

do -- register combo-boxes in the config control dialog
   hexStrToMem(0x4309A0, "E9 CD AC 0D 00")
   hexStrToMem(0x50B672, "8B 16 68 27 04 00 00 89 F1 FF 92 84 01 00 00 8B 06 68 28 04 00 00 89 F1 FF 90 84 01 00 00 8B 16 68 29 04 00 00 89 F1 FF 92 84 01 00 00 8B 06 68 2A 04 00 00 89 F1 FF 90 84 01 00 00 68 12 04 00 00 E9 ED 52 F2 FF 90 90 90 90")
end

do -- register combo-boxes in the config control dialog #2
   hexStrToMem(0x430A85, "E9 32 AC 0D 00 90")
   hexStrToMem(0x50B6BC, "57 68 27 04 00 00 89 F1 E8 A7 57 F2 FF 57 68 28 04 00 00 89 F1 E8 9A 57 F2 FF 57 68 29 04 00 00 89 F1 E8 8D 57 F2 FF 57 68 2A 04 00 00 89 F1 E8 80 57 F2 FF 8B 07 85 C0 0F 84 AE 53 F2 FF E9 8C 53 F2 FF 90")
end

do -- set (init) combo-boxes entries (keys) when the dialog is open
   hexStrToMem(0x430BCC, "E9 2F AB 0D 00")
   hexStrToMem(0x50B700, "E8 2B 5A F2 FF 8B 47 38 57 50 68 27 04 00 00 89 F1 E8 1A 5A F2 FF 8B 47 3C 57 50 68 28 04 00 00 89 F1 E8 09 5A F2 FF 8B 47 40 57 50 68 29 04 00 00 89 F1 E8 F8 59 F2 FF 8B 47 44 57 50 68 2A 04 00 00 89 F1 E8 E7 59 F2 FF E9 83 54 F2 FF 90 90")
end

do -- set movement controls
   hexStrToMem(0x430CF5, "E9 5E AA 0D 00 90 90 90")
   hexStrToMem(0x50B758, "E8 33 5A F2 FF 56 89 46 6C 68 27 04 00 00 89 F9 E8 23 5A F2 FF 56 89 46 38 68 28 04 00 00 89 F9 E8 13 5A F2 FF 56 89 46 3C 68 29 04 00 00 89 F9 E8 03 5A F2 FF 56 89 46 40 68 2A 04 00 00 89 F9 E8 F3 59 F2 FF 89 46 44 E9 55 55 F2 FF 90 90 90")
end

local LPCDIALOGTEMPLATE = ffi.cast("int*", 0x50B654)

local RES = {}

RES.bin = ffi.new("BYTE[1584]") -- should never be collected by GC ! Because of that the module needs to be loaded in CrazyHook.lua with require, and not executed with dofile.

RES.Load = function()
   hexStrToMem(RES.bin, bytes)
   LPCDIALOGTEMPLATE[0] = ffi.cast("int", RES.bin)
end

return RES