--------------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------- [[ Camera module ]] ---------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------------
--[[ This module handles the game's camera (screen position) and contains some functions for manipulating it.]]

local CAM = {PtrCameraObject = nil}

CAM.CameraToPoint = function(x, y)
    if ffi.istype("Point", x) then
        y = x.y
        x = x.x
    end
	mdl_exe.CameraX[0] = x
	mdl_exe.CameraY[0] = y
    local camera = mdl_exe.Camera[0]
    if camera == nil or camera.State == 0 then return end
	camera.State = 8888
end

CAM.CameraToObject = function(object)
	if object == nil then return end
    CAM.CameraToPoint(object.X, object.Y)
end

CAM.SetCameraPoint = function(x, y)
    local camera = mdl_exe.Camera[0]
    if camera == nil or camera.State == 0 then return end
    if ffi.istype("Point", x) then
        y = x.y
        x = x.x
    end
    camera.State = 9000
    local data = camera._d
    data[0] = x
    data[1] = y
    data[2] = data[0]
    data[3] = data[1]
end

CAM.CameraToClaw = function()
    mdl_exe.CameraX[0] = -1
	mdl_exe.CameraY[0] = -1
    local camera = mdl_exe.Camera[0]
    if camera == nil or camera.State == 0 then return end
    if camera.State ~= ClawStates.Crouch and camera.State ~= ClawStates.LookUp then
        camera.State = ClawStates.Stand
    end
end

CAM.SetCameraToPointSpeed = function(speedX, speedY)
    PrivateCast(speedX, "int*", 0x48971D)
    PrivateCast(speedY, "int*", 0x489722)
end

CAM.GetCameraPoint = function()
    return ffi.cast("Point*", Game(9,23)+132)[0]
end

return CAM